/*
 * CSI2131 Winter 2005
 *
 * Assignment#1 Solution : The HtmlTranslator class header
 *
 * by Shantanu Das / Dt: 2005-02-04
 */

#ifndef HTMLTRANSLATOR_H
#define HTMLTRANSLATOR_H


#include <iostream>
#include <string>
#include <fstream>
using namespace std;

const int MAX = 50;				// maximum size for stack

class HtmlTranslator {

	enum listype { NONE=0, ORDERED=1, UNORDERED=-1 };	// the type of list

private:

	istream* inputptr; 
	ostream* outputptr;			// pointers to input & output streams 

	bool new_p;					// are we at the begining of a new paragraph?
	bool new_line;				// are we at the begining of a new line?
	bool new_word;				// are we at the begining of a new word?
	int indent;					// the current indentation
	enum listype curr_list;		// are we inside ORDERED or UNORDERED list?
	int itemnum;				// current item number (for ordered lists)
	

	//-------------------------------------------------------
	// An internal stack for handling nested lists 
	// (NOTE: This can also be written as a seperate class.)
	int* stack;
	int stacktop;
	int stacksize;

	// The Stack methods
	bool stackempty() 
	{	return (stacktop == -1);	}

	bool push(int x) 
	{ 
		if (stacktop < stacksize-1)  stack[++stacktop]=x; 
		else return false;  
		return true;
	}

	int pop() 
	{ 
		if(stacktop >= 0) return stack[stacktop--];  
		else return 0; 
	}
	// ---------------end of stack methods-------------------


	// Methods for handling tags
		void peffect();						// begin new paragraph
		void linebreak();					// begin new line
		void begin_list(enum listype);		// handle <ol> <ul>
		void end_list(enum listype);		// handle </ol> </ul>
		void begin_item();					// handle <li>
		void end_item();					// handle </li>
		void tag_a(string);					// handle <a> tag
		void tag_h(string);					// handle <hn> tag
		void end_h(string);					// handle </hn> tag


	//Methods for writing to output file
		void printout(char);			// print a single character
		void printout(string);			// print a string

		void put_spaces(int n);			// put n space characters
		int eat_spaces();				// skip through sequence of white spaces

public:

	HtmlTranslator(istream&, ostream&);			//Constructor
    virtual ~HtmlTranslator();					//Destructor
	void parse();								//method for parsing the file

};

#endif