/*
 * CSI2131 Winter 2005
 *
 * Assignment#1 Solution : Methods for the HtmlTranslator class
 *
 * by Shantanu Das / Dt: 2005-02-04
 */


#include "HtmlTranslator.h"
#include <ctype.h>

HtmlTranslator::HtmlTranslator(istream& input, ostream& output) {

	new_p = false;				// not at begining of new paragraph
	new_line = true;			// begining of a new line
	new_word = true;			// begining of a new word
	indent = 0;					// no indentation
	listype curr_list = NONE;	// no lists
	itemnum = 0;				// no items

	stack = new int[MAX];		// memory allocation
	stacksize = MAX;			// maximum size of the stack
	stacktop = -1;				// stack is empty initially

	inputptr = &input;
	outputptr = &output;
}


HtmlTranslator::~HtmlTranslator() {

	delete[] stack;					// memory de-allocation
}

void HtmlTranslator::parse() {

	istream& input = *inputptr;
	ostream& output = *outputptr;
	
	while(input.good() && input.peek()!=EOF) {			// while not end of file
 
		char c; 
		string str,tag;
	
		c = input.get();
		if (isspace(c)) {
			c = eat_spaces();			// skip through all spaces
			if(!new_word && c!='<')		// put space if between words
				put_spaces(1);
		}

		else if(c=='<' && !isspace(input.peek())) {		// if start of tag
			tag=""; str="";
			c = input.get();
			while(input.good() && !isspace(c) && c!='>') {	 // read the first word of tag
				tag += tolower(c);						
				c = input.get();
			}
			if (c != '>')							// read the rest of the tag
				getline(input,str,'>');

			if (tag.compare("a")==0)
				tag_a(str);							// handle <a> tag
			else if (tag.compare("p")==0)
				peffect();							// handle <p> tag
			else if (tag.compare("br")==0)
				linebreak();						// handle <br> tag
			else if (tag.compare("ul")==0)
				begin_list(UNORDERED);				// handle <ul> tag
			else if (tag.compare("ol")==0)
				begin_list(ORDERED);				// handle <ol> tag
			else if (tag.compare("li")==0)
				begin_item();						// handle <li> tag
			else if (tag.compare("/li")==0)
				end_item();							// handle </li> tag
			else if (tag.compare("/ul")==0)
				end_list(UNORDERED);				// handle </ul> tag
			else if (tag.compare("/ol")==0)
				end_list(ORDERED);					// handle </ol> tag
			else if (tag.at(0)=='h')
				tag_h(tag);							// handle <hn> tag
			else 
				end_h(tag);							// handle </hn> tag
		}
		else {
			printout(c);							// otherwise output the character read
		}
	}
}



void HtmlTranslator::printout(char c){
										// print the character c to output
	ostream& output = *outputptr;

	if(new_line && indent > 0) 
			put_spaces(indent);			// put proper indentation
	output.put(c);
	new_line = new_p = new_word = false;
}


void HtmlTranslator::printout(string str){
										// print the string str without the extra spaces	
	ostream& output = *outputptr;
	unsigned int i=0;
	while(i < str.size() && isspace(str.at(i))) i++;
	if (i >= str.size()) return;			// nothing to print in str
	
	if(new_line && indent > 0) 
			put_spaces(indent);				// put proper indentation
	if(!new_word) put_spaces(1);
	do {
		while(i < str.size() && !isspace(str.at(i)))	    // output the next word 
			output.put(str.at(i++));				
		while(i < str.size() && isspace(str.at(i))) i++;	// skip spaces
		if(i < str.size()) output.put(' ');					// put space to seperate the next word
	}while(i < str.size());

    new_line = new_p = new_word = false;
}


void HtmlTranslator::peffect()
{
   	ostream& output = *outputptr;
	if(new_p) return;				// ignore tag if new paragraph 
	if(!new_line)
	   output << "\r\n";			// end current line
	output << "\r\n";				// skip another line
	new_p = new_line = new_word = true;
}


void HtmlTranslator::linebreak() {

	ostream& output = *outputptr;

	output << "\r\n";			// end of line
	new_line = new_word = true;
}

void HtmlTranslator::put_spaces(int n)
{										// put 'n' spaces in output file
	ostream& output = *outputptr;
	for(int i=0;i<n;i++) 
		output.put(' ');
	new_word = true;
	new_line = new_p = false;
}


void HtmlTranslator::begin_item() {

	ostream& output = *outputptr;

	if (curr_list==NONE) return;		// we are not inside a list, so ignore "li" tag

	if(!new_line) linebreak();		// begin list item in a new line
	put_spaces(indent);				// put proper indentation
	if(curr_list==ORDERED) { 
		itemnum++;
		output.width(4);
		output << itemnum;
		output << '.' << ' ';
	}
	else output << "    * ";
	new_line = false;
	new_word = true;
	indent +=6;						// increase current indentation
}


void HtmlTranslator::end_item() {		// reached end of list item
	if (indent > 0)			
		indent = indent - 6;			// decrment the current indentation
}


void HtmlTranslator::begin_list(enum listype type) {

	if(curr_list == ORDERED)  push(itemnum);		//store info of outer list, in stack 
	else if(curr_list == UNORDERED)  push(-1);
	curr_list = type;
	itemnum = 0;
	peffect();
}


void HtmlTranslator::end_list(enum listype type) {

	int x = 0;
	if(curr_list != type)  return;		    // bad tag ... ignore it
	if(stackempty()) curr_list = NONE;		// there is no outer list
	else x = pop();
	if (x >= 0)  { curr_list = ORDERED;   itemnum = x; }		//outer list was "ol"
	if (x == -1) { curr_list = UNORDERED; itemnum = 0; }		//outer list was "ul"
	peffect();
}



void HtmlTranslator::tag_a(string str){
	
	istream& input = *inputptr;
	int i = str.find("href=\"",0);			// find the position of "href=""
	if(i==string::npos)  i = str.find("HREF=\"",0);
	if(i==string::npos)  return;        /// wrong <a> tag...doesnot have "href"
	i+=6;								// 'i' is starting position of link 
	int j = str.find('"',i);			// 'j' is ending position of link
	string link = str.substr(i,j-i);
	getline(input,str,'<');				   // read up to start of </a>
	if(input.good()) input.putback('<');   // the </a> tag would be read next time
	printout(str+" <"+link+">");
	return ;
}


void HtmlTranslator::tag_h(string tag) {	// handle <hn> tag
	
	ostream& output = *outputptr;

	int n = atoi(tag.substr(1).c_str());		// convert the digit to number
	if(n >= 1 && n <= 6) {					// check for "h1" to "h6"
        peffect();
		char c = eat_spaces();
		if (c != '<')						// if header contains some text
			put_spaces(2*n);
	}
}

void HtmlTranslator::end_h(string tag) {	// handle </hn> tag

	if (tag.size() > 2)
		if (tag.at(0)=='/' && tag.at(1)=='h' && isdigit(tag.at(2)))
				peffect();					
}


int HtmlTranslator::eat_spaces()		//eat-up all white spaces begining from current
{										// location in input file, and return the first non-space char. 
	istream& input = *inputptr;

	char c = input.peek();
	while( isspace(c) && input.good())
	{
	 	input.get();
		c = input.peek();
	}
	return c;
}



