/*
 * CSI2131 Winter 2005
 *
 * Assignment#3 Solution : The main function
 *
 * Shantanu Das 
 *
 * This is the main program that inputs the filenames from command line, 
 * opens the files and creates various indexes and executes operations on them.
 * (Result of operations are printed in "Results.txt".)
 * Statistics for the various indexes are printed on-screen.
 * 
 * The following classes are used : Record, Index, DataFile, and IndexedDatafile
 */


#include "Index.h"
#include "DataFile.h"
#include "IndexedDatafile.h"
#include <iostream>
#include <fstream>
#include <string>
using namespace std;


// global hash functions...

int h1(long k, int n){
	long long k2 = k;
	k2 = (k2*k2)/1048576;
	return (k2 % n);
}
int g1(long k, int n){
	long long k2 = k;
	k2 = (k2*k2)/65536;
	return (k2 % n);
}
int h2(long k, int n){
	long res = k / 1280;
	return (res % n);
}
int g2(long k, int n){
	long res = k / 65536;
	return (res % n);
}


// Parameters for Hashed Indexes
int N[8] = {1009,1009,419,419,1511,1511,277,277 };
int B[8] = {   1,   1,  2,  2,   1,   1,  3,  3 };
int (*fpArr[8][2])(long,int) = { 
								{&h1, NULL},
								{&h1, &h2},
								{&h1, NULL},
								{&h1, &h2},
								{&g1, NULL},
								{&g1, &g2},
								{&g1, NULL},
								{&g1, &g2}
							   };


// main method ... uses command line arguments
int main(int argc,char* argv[])
{
   
  fstream dfile;		// datafile stream
  fstream opfile;		// operations file stream
  fstream hfs[8];		// hash-file streams
  
  
  // check for the correct number of arguments.
  if(argc!=3){
	  cerr << "USAGE: " << argv[0] << " <Data-file> <Operations-file>" << endl;
	  return 1;
  }

  // open the file for input
  dfile.open(argv[1], ios::in|ios::out|ios::binary|ios::app);

  // Check to make sure that we could open the file properly!
  if (dfile.fail()) {
    cerr << "Could not open file ";
    cerr << argv[1];
    cerr << endl;
    return 1;
  }

  // open the output file in binary mode
  opfile.open(argv[2], ios::in);

  // Check to make sure that we could open the file properly!
  if (opfile.fail()) {
    cerr << "Could not open file ";
    cerr << argv[2];
    cerr << endl;
    return 1;
  }

  DataFile df(dfile);				// create data-file object
  IndexedDatafile *indf[8];			// array for indexed-datafiles
  fstream res;						// to store the results
  res.open("Results.txt", ios::out|ios::trunc);
  if (res.fail()) {
	cerr << "Could not create file : Results.txt" << endl;
	return 1;
  }

  for(int i=0;i<8;i++) {			

		char fname[10];
		sprintf(fname,"hf%d.txt",i+1);
								// create the file for storing the index 
		hfs[i].open(fname, ios::out|ios::in|ios::binary|ios::trunc);
		if (hfs[i].fail()) {
			cerr << "Could not create file : " << fname << endl;
			return 1;
		}
 
		int num = 0;		// create the Indexed-datafile object
		indf[i] = new IndexedDatafile(df,N[i],B[i],fpArr[i][0],fpArr[i][1],&hfs[i]);

		num = indf[i]->createIndex();	// construct initial index

		cout << "Executing Operations from "<< argv[2] << " using " << fname << endl;
		opfile.seekg(0,ios::beg);
		opfile.clear();
		res << "HASH-FILE "<< (i+1) << endl;
		num = indf[i]->executeOp(opfile,res);
		cout << num << " Operations executed successfully !" << endl;
  }

  cout << "\n\nStatistical Data for the various hash-files: " << endl;
  cout << "------------------------------------------------------------------------" << endl;
  cout << "Hash-file  Average-Search-Length  Maximum-Search-Length  Packing-Density" << endl;
  cout << "------------------------------------------------------------------------" << endl;
  for(int i=0,j=1;i<8;i++,j++) {
	  cout << "hf"<<j<<".txt" << "        " << flush; 
	  indf[i]->printStats(cout);
	  cout << endl;
  }
  cout << "------------------------------------------------------------------------" << endl;

  dfile.close();            // Close the files
  opfile.close();
  for(int i=0;i<8;i++)
	  hfs[i].close();

  // Program completed successfully! */
  return 0;
}





