/*
 * CSI2131 Winter 2005
 *
 * Assignment#3 Solution : The Record class
 *(Stores and manipulates a single record)
 * (same as in A2)
 *
 * Shantanu Das 
 */

#ifndef RECORD_H
#define RECORD_H


#include <iostream>
#include <string>
#include <fstream>
using namespace std;

const int START = 1997;		//Starting year.

class Record {

private:

	int year;				// year in the range 0-84
	int term;  				// Fall(0), Winter(1), or Summer(2)
	char *code;			    // course code
	char section;	 		// course section
	char *cname,*pname,*clink,*plink;		//course-name, prof's name, course-link and prof's homepage
	int s5,s6,s7,s8;        // sizes of field-5 to field-8

	int size;				// size of the record in bytes
	long key;				// the primary key
		
public:

	Record();				//Constructor
    virtual ~Record();		//Destructor
	long makekey();			//method for constructing the key
	long getkey();
	int getsize();
					// functions for setting the value of the fields 
	void setyear(int);				
	void setterm(int);
	void setcode(const char*);
	void setsec(char);
	void setcname(const char*,int);
	void setpname(const char*,int);
	void setclink(const char*,int);
	void setplink(const char*,int);

	int read(istream& fs);      // reads the record from datafile fs
	int write(ostream& fs);		//writes the record (in compact form) to fs
	void printall(ostream& fs);	// displays the whole record, in readable format
	void printkey(ostream& fs);	// displays the key part of record, in readable format
};

#endif