/*
 * CSI2131 Winter 2005
 *
 * Assignment#3 Solution : The IndexedDatafile class
 * Handles both the index and the datafile 
    reads the operations file and executes operations.
 * ( Changes from A2: Modified constructor and added method "printStats",
 *   Output of operations is printed in a file. )
 *
 * Shantanu Das 
 */

#ifndef INDEXED_DATAFILE_H
#define INDEXED_DATAFILE_H

#include "Record.h"
#include "Index.h"
#include "DataFile.h"
#include <iostream>
#include <string>
#include <fstream>
using namespace std;

class IndexedDatafile {

private:

	Index *ind;				// Pointer to the index object
    DataFile *dfp;			// Pointer to the datafile object
	Record *rp;				// Pointer to Record for internal use

	//internal functions
	void search(Record& rec, fstream& out);			// execute search operation and print results
	void insert(Record& rec, fstream& out);			// execute insert operation and print results
	void readData(fstream& fs,Record &rec);  // input the fields of the record to be inserted

public:

	//Constructor
	IndexedDatafile(DataFile& x,int n,int b,int (*fp1)(long,int),int (*fp2)(long,int),fstream *hfs);
    virtual ~IndexedDatafile();			//Destructor
	int createIndex();				// create the index for existing records in datafile
	int executeOp(fstream &fs, fstream& out);    // execute operations from file fs
	void printStats(ostream& fs);		// method for printing the statistics
};

#endif