/*
 * CSI2131 Winter 2005
 *
 * Assignment#3 Solution : The Index class
 * Implements a hashed index (using buckets)
 * Collision Resolution: Either progressive overflow (using hash-function -> hfunc1)
 *                       Or, double hashing (using functions -> hfunc1 and hfunc2)
 *
 * Author: Shantanu Das 
 */

#ifndef INDEX_H
#define INDEX_H


#include <iostream>
#include <fstream>
using namespace std;

const int minsize = 50;

class Index {

	struct ind_item {  
		long key; 
		long offset; 
	};

private:

	unsigned int size;			// size of the index (N)
	unsigned int BS;			// bucket size (B)
	unsigned int numentries;		// number of entries in the index

	int (*hfunc1)(long,int);		// pointer to hash-function-1
	int (*hfunc2)(long,int);		// pointer to hash-function-2
	fstream *hfileptr;				// pointer to file that stores the hashed-index

// Internal variables
	struct ind_item *Bucket;		// to store a Bucket containing index entries
	int SL;							// current search length
	int pos;						// position of current Bucket read from index

// Statistical data
	float avgSL;					// Average Search Length
	int maxSL;						// Maximum Search Length
	float pack_density;				// Packing Density

private:
	bool readbucketatRRN(int);			// reads the bucket at given RRN (returns true for success)
	bool writebucketatRRN(int);		// writes the bucket at given RRN (returns true for success)

public:

	Index(int n, int b, int (*fp1)(long,int), int (*fp2)(long,int), fstream *hfs);	// Constructor
	virtual ~Index();				// Destructor
	bool insert(long k,long ofs);		// method for inserting new entry into the index (returns true for success)
	long search(long k);			// search for the key k and return its offset
									// ( returns -1 for error )
	// functions returning the statistics
	float averageSL()		{ return avgSL; }
	int maximumSL()			{ return maxSL;  }
	float PackingDensity()	{ return pack_density; }
		
};

#endif