/*
 * CSI2131 Winter 2005
 *
 * Assignment#3 Solution : Implementation of The Index class
 * (using hashed index stored in a file)
 *
 * Shantanu Das 
 */


#include "Index.h"


// Constructor -> creates an empty index 
Index::Index(int n,int b,int (*fp1)(long,int),int (*fp2)(long,int),fstream *hfs) 
{
	size = n;					// set the size to N
	BS = b;						// set the value of bucket size
	hfunc1 = fp1;				// set pointers to hash-functions ...
	hfunc2 = fp2;
	hfileptr = hfs;
	numentries = 0;				// Currently, no entries in the index. 
	avgSL = 1.0;				// Initialize the data
	maxSL = 1;
	pack_density = 0;
	SL = pos = 0;

	Bucket = new ind_item[BS];		//allocate memory for storing a bucket
	if(Bucket==NULL)  {
		cerr<<"Error: Can't allocate memory..."<<endl; 
		exit(1);
	}

	long zero = 0;
	hfileptr->seekp(0,ios::beg);		
	for(unsigned i=0;i < size*BS;i++){		// Initialize the hash-file with zero's for a blank table.
		hfileptr->write((char *)&zero,4);
		hfileptr->write((char *)&zero,4);
	}
	hfileptr->clear();				// clear the flag for future reads.
	hfileptr->seekg(0,ios::beg);
}

//Destructor
Index::~Index() 
{ 
	delete[] Bucket;
}

bool Index::insert(long k, long ofs)
{
	if(numentries == size*BS) {				// check if hash-table is full
		cerr << "\nError: Overflow...Index is Full !!" << endl;
		exit(1);
	}
	search(k);				// call search method to read in the correct bucket
	unsigned int i=0;
	while( i<BS && Bucket[i].key!=0) i++;    // go to first empty position in bucket
	Bucket[i].key = k;						// put new entry in bucket
	Bucket[i].offset = ofs;
	if(writebucketatRRN(pos)==false) {			// write the bucket at proper position
		cerr << "\nError writing to hashfile!!" << endl;
		exit(1);
	}

	if(SL > maxSL) 
		maxSL = SL;						// update maximum search length
	avgSL = (avgSL*numentries + SL) / (numentries+1);	//update average search length
	numentries++;						// update number of entries
	pack_density = numentries / ((float)size*BS);	//update the packing density
	return true;
}


long Index::search(long k)			// search for the key k 
{							// return the offset, if found; return -1 otherwise.

	pos = (*hfunc1)(k,size);			// calculate hash-address
	int start = pos;			// position at which search started
	int inc = 1;				// increment = 1 (for progressive overflow) 
	SL = 0;
	if(hfunc2!=NULL)
		inc = (*hfunc2)(k,size);	// calculate increment (for double hashing)

	do 
	{							// read a bucket from hashfile
		if(readbucketatRRN(pos)==false) {
			cerr << "\nError reading from hashfile!!" << endl;
			exit(1);
		} 
		SL++;					// increment search length.
		for (unsigned i=0;i<BS;i++) {
			if(Bucket[i].key==k)			// found key k
				return Bucket[i].offset;
			else if(Bucket[i].key==0)		// Not found
				return -1;
		}
		pos = (pos+inc)%size;		// go to next position
	}while(pos!=start);

	return -1;							// Not found
}


bool Index::readbucketatRRN(int rrn)			//to read a bucket at the given RRN		
{
	fstream& hfile = *hfileptr;
	hfile.clear();
	hfile.seekg(rrn*BS*8,ios::beg);		// seek to the proper offset
	unsigned int i = 0;
	while(hfile.good()&& i < BS) {		// read the index entries into bucket
		hfile.read((char *)&Bucket[i].key,4);
		hfile.read((char *)&Bucket[i].offset,4);
		i++;
	}
	if(i==BS) return true;
	else return false;
}

bool Index::writebucketatRRN(int rrn)		//to write a bucket at the given RRN
{
	fstream& hfile = *hfileptr;
	hfile.clear();
	hfile.seekp(rrn*BS*8,ios::beg);		// seek to the proper offset
	unsigned int i = 0;
	while(hfile.good()&& i < BS) {		// write the index entries from bucket
		hfile.write((char *)&Bucket[i].key,4);
		hfile.write((char *)&Bucket[i].offset,4);
		i++;
	}
	if(i==BS) return true;
	else return false;
}

